/*
 * Decompiled with CFR 0.152.
 */
package birchconfig;

import birchconfig.BirchProperties;
import birchconfig.BufferedTextOutputFile;
import birchconfig.MainFrame;
import birchconfig.URLholder;
import birchconfig.customdoc;
import birchconfig.helpFrame;
import birchconfig.urlBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class configDocFrame
extends JFrame {
    MainFrame frame;
    BirchProperties BP;
    URLholder birchURLcandidate;
    URLholder birchHomeURLcandidate;
    JPanel TitlePanel = new JPanel();
    JLabel TitleLabel = new JLabel("Change URLs in BIRCH documentation");
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel WebPanel = new JPanel();
    JRadioButton WebButton = new JRadioButton("Make Documentation  Web Accessible");
    JTextField birchURLText = new JTextField();
    JLabel birchURLtitle = new JLabel("URL for BIRCH Web site");
    JButton birchURLButton = new JButton("URL Builder");
    JTextField birchHomeURLText = new JTextField();
    JLabel birchHomeURLtitle = new JLabel("URL for BIRCH Home Directory");
    JButton birchHomeURLButton = new JButton("URL Builder");
    JRadioButton LocalButton = new JRadioButton("Make documentation accessible only by local login");
    JPanel LocalPanel = new JPanel();
    JTextField LocalBirchURLText = new JTextField();
    JLabel LocalBirchURLLabel = new JLabel("URL for BIRCH Web Site");
    JLabel LocalBirchHomeURLLabel = new JLabel("URL for BIRCH Home Directory");
    JTextField LocalBirchHomeText = new JTextField();
    JPanel RetApplyHelpPanel = new JPanel();
    JButton returnButton = new JButton("Return to Main Menu");
    JButton ApplyButton = new JButton("Apply");
    JButton helpButton = new JButton("Help");
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    TitledBorder titledBorder1 = new TitledBorder("");
    Border border1 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(103, 101, 98), new Color(148, 145, 140));

    public configDocFrame(MainFrame tempframe, BirchProperties tempBP) {
        try {
            this.BP = tempBP;
            this.frame = tempframe;
            this.jbInit(this.frame, this.BP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(MainFrame frame, BirchProperties BP) throws Exception {
        String FN = "../local/admin/BIRCH.properties";
        try {
            BP.loadProps(FN);
        }
        catch (Exception e) {
            System.out.println(e);
            Toolkit.getDefaultToolkit().beep();
            String message = "Can't load properties from " + FN;
            JOptionPane.showMessageDialog(frame, message);
            this.dispose();
        }
        this.birchURLcandidate = new URLholder(BP);
        this.birchURLcandidate.URLtitle = "URL for BIRCH web site";
        this.birchURLcandidate.URLTextField = this.birchURLText;
        this.birchURLcandidate.makeURLstring();
        this.birchHomeURLcandidate = new URLholder(BP);
        this.birchHomeURLcandidate.URLtitle = "URL for BIRCH home directory";
        this.birchHomeURLcandidate.useridDir = this.birchHomeURLcandidate.useridDir + "/birchhomedir";
        this.birchHomeURLcandidate.URLTextField = this.birchHomeURLText;
        this.birchHomeURLcandidate.makeURLstring();
        this.getContentPane().setBackground(Color.orange);
        this.setTitle("birchconfig");
        this.setSize(600, 575);
        this.getContentPane().setLayout(this.gridBagLayout5);
        this.TitlePanel.setBackground(Color.white);
        this.TitlePanel.setFont(new Font("Dialog", 1, 12));
        this.TitlePanel.setOpaque(false);
        this.TitlePanel.setLayout(this.gridBagLayout3);
        this.TitleLabel.setFont(new Font("Dialog", 1, 12));
        this.TitleLabel.setForeground(Color.red);
        this.TitleLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.TitleLabel.setOpaque(true);
        this.TitleLabel.setHorizontalAlignment(0);
        this.TitleLabel.setHorizontalTextPosition(0);
        this.TitleLabel.setBackground(Color.white);
        this.WebButton.setSelected(true);
        this.birchURLText.setBackground(Color.white);
        this.birchHomeURLText.setBackground(Color.white);
        this.LocalPanel.setLayout(this.gridBagLayout1);
        this.LocalBirchHomeText.setBackground(Color.white);
        this.LocalBirchHomeText.setEditable(false);
        this.LocalBirchHomeText.setText("file://" + BP.homedir);
        this.LocalBirchURLText.setBackground(Color.white);
        this.LocalBirchURLText.setEditable(false);
        this.LocalBirchURLText.setText("file://" + BP.homedir + "/public_html");
        this.LocalPanel.setBackground(SystemColor.window);
        this.LocalPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.LocalButton.setBackground(SystemColor.window);
        this.LocalButton.setFont(new Font("Dialog", 1, 14));
        this.WebPanel.setBackground(SystemColor.window);
        this.WebPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.birchHomeURLButton.setHorizontalAlignment(2);
        this.birchURLButton.setHorizontalTextPosition(0);
        this.TitlePanel.add((Component)this.TitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 53, 5));
        this.WebButton.setBackground(SystemColor.window);
        this.WebButton.setFont(new Font("Arial", 1, 14));
        this.WebButton.setForeground(Color.black);
        this.WebButton.setOpaque(false);
        this.birchURLText.setText(this.birchURLcandidate.URLstr);
        this.birchURLButton.addActionListener(new configDocFrame_birchURLButton_actionAdapter(this));
        this.birchURLButton.setSize(new Dimension(125, 100));
        this.birchURLButton.setAlignmentX(0.0f);
        this.birchURLButton.setAlignmentY(0.5f);
        this.birchURLButton.setMaximumSize(new Dimension(125, 36));
        this.birchURLButton.setPreferredSize(new Dimension(125, 36));
        this.birchURLButton.setToolTipText("Launch URL Builder");
        this.birchHomeURLText.setText(this.birchHomeURLcandidate.URLstr);
        this.birchHomeURLButton.addActionListener(new configDocFrame_birchHomeURLButton_actionAdapter(this));
        this.birchHomeURLButton.setSize(new Dimension(125, 100));
        this.birchHomeURLButton.setAlignmentX(0.0f);
        this.birchHomeURLButton.setAlignmentY(0.5f);
        this.birchHomeURLButton.setMaximumSize(new Dimension(125, 36));
        this.birchHomeURLButton.setPreferredSize(new Dimension(125, 36));
        this.birchHomeURLButton.setToolTipText("Launch URL Builder");
        this.birchHomeURLButton.setHorizontalTextPosition(0);
        this.WebPanel.setLayout(this.gridBagLayout4);
        this.buttonGroup1.add(this.WebButton);
        this.buttonGroup1.add(this.LocalButton);
        this.RetApplyHelpPanel.setLayout(this.gridBagLayout2);
        this.RetApplyHelpPanel.setOpaque(false);
        this.returnButton.setHorizontalTextPosition(0);
        this.returnButton.setHorizontalAlignment(0);
        this.returnButton.setText("Return to Main Menu");
        this.returnButton.addActionListener(new configDocFrame_returnButton_actionAdapter(this));
        this.ApplyButton.setHorizontalTextPosition(0);
        this.ApplyButton.addActionListener(new configDocFrame_ApplyButton_actionAdapter(this));
        this.ApplyButton.setText("Apply");
        this.helpButton.setHorizontalTextPosition(0);
        this.helpButton.setHorizontalAlignment(0);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new configDocFrame_helpButton_actionAdapter(this));
        this.RetApplyHelpPanel.add((Component)this.returnButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 10, 0));
        this.RetApplyHelpPanel.add((Component)this.ApplyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 10, 0));
        this.RetApplyHelpPanel.add((Component)this.helpButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 10, 0));
        this.LocalPanel.add((Component)this.LocalBirchURLLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(13, 156, 0, 254), 0, 8));
        this.LocalPanel.add((Component)this.LocalBirchHomeURLLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 156, 0, 202), 19, 9));
        this.LocalPanel.add((Component)this.LocalBirchURLText, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 34, 0, 125), 394, 12));
        this.LocalPanel.add((Component)this.LocalBirchHomeText, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 36, 21, 125), 393, 15));
        this.WebPanel.add((Component)this.birchURLtitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 140, 0, 121), 47, 8));
        this.WebPanel.add((Component)this.birchHomeURLtitle, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 140, 0, 90), 43, 8));
        this.WebPanel.add((Component)this.birchURLText, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 19), 397, 12));
        this.WebPanel.add((Component)this.birchHomeURLText, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 19, 21), 397, 12));
        this.WebPanel.add((Component)this.birchHomeURLButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 13, 4), 3, 17));
        this.WebPanel.add((Component)this.birchURLButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 13, 4), 3, 17));
        this.getContentPane().add((Component)this.TitlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 18, 0, 15), 251, 30));
        this.getContentPane().add((Component)this.RetApplyHelpPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 17, 7, 11), 245, 23));
        this.getContentPane().add((Component)this.WebPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 18, 0, 14), 0, -6));
        this.LocalPanel.add((Component)this.LocalButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 4, 0, 127), 187, 0));
        this.WebPanel.add((Component)this.WebButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 3, 0, 19), 122, 0));
        this.getContentPane().add((Component)this.LocalPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 1, new Insets(12, 18, 0, 13), 0, 8));
    }

    public static void main(String[] args) {
    }

    public void birchURLButton_actionPerformed(ActionEvent e) {
        urlBuilder builder = new urlBuilder(this, this.BP, this.birchURLcandidate);
        builder.setVisible(true);
        this.setEnabled(false);
    }

    public void birchHomeURLButton_actionPerformed(ActionEvent e) {
        urlBuilder builder = new urlBuilder(this, this.BP, this.birchHomeURLcandidate);
        builder.setVisible(true);
        this.setEnabled(false);
    }

    public void returnButton_actionPerformed(ActionEvent e) {
        this.dispose();
        this.frame.setVisible(true);
    }

    private void maketempParamFile(String FN, String[] urlLines) {
        BufferedTextOutputFile outfile = new BufferedTextOutputFile();
        if (outfile.WriteOkay(FN)) {
            System.out.println("Creating " + FN);
            try {
                outfile.PW.println(urlLines[0]);
                outfile.PW.println(urlLines[1]);
                outfile.PW.flush();
                outfile.FW.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void ApplyButton_actionPerformed(ActionEvent e) {
        Toolkit.getDefaultToolkit().beep();
        String message = "Do you really want to change URLs in documentation?";
        int response = JOptionPane.showConfirmDialog(this.frame, message);
        if (response == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String[] oldstrings = new String[]{this.BP.birchURL, this.BP.birchHomeURL};
            this.maketempParamFile("oldURLs.param", oldstrings);
            String[] newstrings = new String[2];
            if (this.WebButton.isSelected()) {
                newstrings[0] = this.birchURLText.getText();
                newstrings[1] = this.birchHomeURLText.getText();
            } else {
                newstrings[0] = this.LocalBirchURLText.getText();
                newstrings[1] = this.LocalBirchHomeText.getText();
            }
            this.maketempParamFile("newURLs.param", newstrings);
            customdoc.main();
            File oldfile = new File("oldURLs.param");
            File newfile = new File("newURLs.param");
            this.setCursor(Cursor.getPredefinedCursor(0));
            Toolkit.getDefaultToolkit().beep();
            String changemessage = "Changes complete.";
            JOptionPane.showMessageDialog(this.frame, changemessage);
        }
        System.exit(0);
    }

    public void helpButton_actionPerformed(ActionEvent e) {
        helpFrame Help = new helpFrame("birchconfig/help/BIRCHweb.help.html");
        Help.setVisible(true);
    }

    class configDocFrame_helpButton_actionAdapter
    implements ActionListener {
        private configDocFrame adaptee;

        configDocFrame_helpButton_actionAdapter(configDocFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.helpButton_actionPerformed(e);
        }
    }

    class configDocFrame_ApplyButton_actionAdapter
    implements ActionListener {
        private configDocFrame adaptee;

        configDocFrame_ApplyButton_actionAdapter(configDocFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.ApplyButton_actionPerformed(e);
        }
    }

    class configDocFrame_returnButton_actionAdapter
    implements ActionListener {
        private configDocFrame adaptee;

        configDocFrame_returnButton_actionAdapter(configDocFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.returnButton_actionPerformed(e);
        }
    }

    class configDocFrame_birchHomeURLButton_actionAdapter
    implements ActionListener {
        private configDocFrame adaptee;

        configDocFrame_birchHomeURLButton_actionAdapter(configDocFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.birchHomeURLButton_actionPerformed(e);
        }
    }

    class configDocFrame_birchURLButton_actionAdapter
    implements ActionListener {
        private configDocFrame adaptee;

        configDocFrame_birchURLButton_actionAdapter(configDocFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.birchURLButton_actionPerformed(e);
        }
    }
}

