/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.Main;
import install.OutputConsole;
import install.StreamCopier;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileSystemView;

public class BIRCHIO {
    public static final File JAR_PATH = BIRCHIO.getJarPath();
    public static final int ONE_KB = 1024;
    public static final int EIGHT_KB = 8192;
    public static final int ONE_MB = 0x100000;
    public static final int BUFFSIZE = 8192;
    public static final File DEFAULT_HOME = FileSystemView.getFileSystemView().getDefaultDirectory();

    public static boolean wget(URL location, File fout, OutputConsole logger, boolean temp) throws IOException {
        boolean success = false;
        long size = -1L;
        URLConnection connect = location.openConnection();
        size = connect.getContentLength();
        if (logger != null) {
            logger.println("Fetching " + fout + " from " + location);
        }
        boolean bl = success = fout.createNewFile() || fout.exists();
        if (temp) {
            fout.deleteOnExit();
        }
        if (success) {
            FileOutputStream outs = new FileOutputStream(fout);
            byte[] buffer = new byte[8192];
            if (size >= 0L && logger != null) {
                logger.setProgress(0);
                logger.setIndeterminate(false);
                logger.println("size: " + size);
            }
            try {
                if (logger != null) {
                    StreamCopier.streamcopy(buffer, location.openStream(), outs, logger, 0L, size);
                } else {
                    StreamCopier.streamcopy(buffer, location.openStream(), outs);
                }
            }
            catch (Exception ex) {
                success = false;
            }
            outs.flush();
            outs.close();
        } else if (logger != null) {
            logger.println("DOWNLOAD FAILED!");
        } else {
            System.out.println("DOWNLOAD FAILED!");
        }
        if (!success) {
            if (logger != null) {
                logger.println("DOWNLOAD FAILED!");
            } else {
                System.out.println("DOWNLOAD FAILED!");
            }
        }
        if (logger != null) {
            logger.setProgressTask("");
            logger.setIndeterminate(true);
        }
        return success;
    }

    public static boolean copy(File source, File dest, OutputConsole console, boolean temp) throws IOException {
        boolean success = false;
        long size = source.length();
        console.setProgress(0);
        console.setIndeterminate(false);
        success = dest.createNewFile();
        if (success) {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[8192];
            console.setProgressTask("Copying " + source + " to " + dest);
            StreamCopier.streamcopy(buffer, in, out, console, 0L, size);
            out.flush();
            out.close();
            if (temp) {
                dest.deleteOnExit();
            }
        }
        console.setProgressTask("");
        console.setIndeterminate(true);
        return success;
    }

    public static void untar(File todecompress, File path, PrintStream stdout, PrintStream err, boolean temp) throws IOException {
        File tar;
        String basename = todecompress.getAbsolutePath();
        System.gc();
        if (Main.IS_WINDOWS && Main.WIN_GZ != null && Main.WIN_TAR != null) {
            BIRCHIO.runCommand(new String[]{Main.WIN_GZ.getAbsolutePath(), basename}, null, path, stdout, err);
            stdout.flush();
            err.flush();
            BIRCHIO.runCommand(new String[]{Main.WIN_TAR.getAbsolutePath(), "xf", basename.substring(0, basename.lastIndexOf(".gz"))}, null, path, stdout, err);
        } else {
            BIRCHIO.runCommand(new String[]{"gunzip", basename}, null, path, stdout, err);
            stdout.flush();
            err.flush();
            BIRCHIO.runCommand(new String[]{"tar", "-xvpf", basename.substring(0, basename.lastIndexOf(".gz"))}, null, path, stdout, err);
        }
        if (temp && (tar = new File(basename.substring(0, basename.lastIndexOf(".gz")))).exists()) {
            tar.deleteOnExit();
        }
    }

    public static void add_tar(File tar_file, File path, PrintStream stdout, PrintStream err) {
        if (Main.IS_WINDOWS && Main.WIN_GZ != null && Main.WIN_TAR != null) {
            BIRCHIO.runCommand(new String[]{Main.WIN_TAR.getAbsolutePath(), "rf", tar_file.getAbsolutePath(), path.getAbsolutePath()}, null, path, stdout, err);
        } else {
            BIRCHIO.runCommand(new String[]{"tar", "-rvpf", tar_file.getAbsolutePath(), path.getAbsolutePath()}, null, path, stdout, err);
        }
    }

    public static boolean cleanUp(File toDelete) {
        boolean success = false;
        if (toDelete.isDirectory()) {
            for (File file : toDelete.listFiles()) {
                success &= BIRCHIO.cleanUp(file);
            }
        }
        success = toDelete.delete();
        return success;
    }

    public static File extract_temp(String resource, String prefix, String suffix) {
        File destination = null;
        try {
            destination = File.createTempFile(prefix, suffix);
            BIRCHIO.extract(resource, destination, true);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        return destination;
    }

    private static void extract(String resource, File destination, boolean temp) {
        System.out.println("EXTRACTING: " + resource + " TO: " + destination);
        try {
            if (destination.canWrite()) {
                InputStream is = BIRCHIO.class.getResourceAsStream(resource);
                FileOutputStream os = new FileOutputStream(destination);
                byte[] buffer = new byte[1024];
                if (is != null) {
                    StreamCopier.streamcopy(buffer, is, os);
                    if (temp) {
                        destination.deleteOnExit();
                    }
                } else {
                    System.out.println("ERROR OPENING RESOURCE FROM JAR! - " + resource);
                    System.exit(0);
                }
                os.flush();
                ((OutputStream)os).close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    public static int runCommand(String[] execute, String[] envp, File path, PrintStream stdout, PrintStream err) {
        int status = -1;
        Process process = null;
        StringBuilder execString = new StringBuilder();
        execString.append("executing -");
        for (String cmd : execute) {
            execString.append(" ");
            execString.append(cmd);
        }
        stdout.println(execString.toString());
        try {
            process = Runtime.getRuntime().exec(execute, envp, path);
            if (process != null) {
                Thread stdoutThread = new Thread(new StreamCopier(16384, process.getInputStream(), stdout));
                Thread stderrThread = new Thread(new StreamCopier(16384, process.getErrorStream(), err));
                stdoutThread.start();
                stderrThread.start();
                process.getOutputStream().close();
                status = process.waitFor();
                stdoutThread.join();
                stderrThread.join();
                stdout.println("Command finished execution, return status: " + status);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(err);
        }
        return status;
    }

    private static File getJarPath() {
        URL url = BIRCHIO.class.getProtectionDomain().getCodeSource().getLocation();
        File parent = null;
        try {
            parent = new File(url.toURI().getPath().replaceFirst("^file:", "").replaceAll("getbirch\\.jar.*$", ""));
            while (parent.exists() && !parent.isDirectory()) {
                parent = parent.getParentFile();
            }
        }
        catch (Exception ioe) {
            parent = new File(System.getProperty("user.dir"));
        }
        return parent;
    }

    public static void compress(ZipOutputStream zout, File file) throws IOException {
        byte[] buffer = new byte[8192];
        if (file.exists() && file.isDirectory()) {
            File[] subfiles = file.listFiles();
            for (int i = 0; i < subfiles.length; ++i) {
                if (!subfiles[i].exists()) continue;
                BIRCHIO.compress(zout, subfiles[i]);
            }
        } else {
            ZipEntry ze = new ZipEntry(file.getAbsolutePath());
            FileInputStream in = new FileInputStream(file.getAbsolutePath());
            ze.setComment(file.canExecute() ? "exec" : "");
            ze.setTime(file.lastModified());
            System.out.println(" Adding: " + file.getAbsolutePath());
            zout.putNextEntry(ze);
            StreamCopier.streamcopy(buffer, in, zout);
            zout.closeEntry();
            in.close();
        }
    }

    public static void unzip(File zf, File destDir) throws IOException {
        FileInputStream fis = new FileInputStream(zf);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = null;
        byte[] buffer = new byte[8192];
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.isDirectory()) continue;
            File dest = new File(destDir, ze.getName());
            File parentDir = dest.getParentFile();
            FileOutputStream fout = new FileOutputStream(dest);
            parentDir.mkdirs();
            dest.createNewFile();
            dest.setLastModified(ze.getTime());
            if ("exec".equalsIgnoreCase(ze.getComment())) {
                dest.setExecutable(true);
            }
            StreamCopier.streamcopy(buffer, zis, fout);
            fout.flush();
            fout.close();
        }
        zis.close();
    }

    public static long getPathSize(File path) {
        long length = 0L;
        if (path.isDirectory()) {
            for (File subfile : path.listFiles()) {
                length += BIRCHIO.getPathSize(subfile);
            }
        } else {
            length = path.length();
        }
        return length;
    }

    public static String oneLineFile(URL path) throws IOException {
        String result = null;
        BufferedReader breader = new BufferedReader(new InputStreamReader(path.openStream()));
        result = breader.readLine();
        if (result != null) {
            result.trim();
        }
        breader.close();
        return result;
    }
}

