/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.OutputConsole;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopier
implements Runnable {
    private InputStream in;
    private OutputStream out;
    private byte[] buffer;
    private long start_size = -1L;
    private long max_size = -1L;
    private OutputConsole console = null;
    public static final int DEFAULT_BUFF_SIZE = 16384;

    public StreamCopier(int buffsize, InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.buffer = new byte[buffsize];
    }

    public StreamCopier(int buffsize, InputStream in, OutputStream out, OutputConsole console, long start_size, long max_size) {
        this.in = in;
        this.out = out;
        this.buffer = new byte[buffsize];
        this.console = console;
        this.start_size = start_size;
        this.max_size = max_size;
    }

    @Override
    public void run() {
        if (this.console != null) {
            try {
                StreamCopier.streamcopy(this.buffer, this.in, this.out, this.console, this.start_size, this.max_size);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        } else {
            try {
                StreamCopier.streamcopy(this.buffer, this.in, this.out);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
    }

    public static void streamcopy(byte[] buffer, InputStream in, OutputStream out) throws IOException {
        int len = 0;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            out.flush();
        }
    }

    public static void streamcopy(byte[] buffer, InputStream in, OutputStream out, OutputConsole console, long start_size, long max_size) throws IOException {
        int len = 0;
        long progress = start_size;
        int curr_pcentprog = 0;
        int old_pcentprog = 0;
        try {
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                if (console == null || max_size == -1L) continue;
                curr_pcentprog = (int)Math.round((double)(progress += (long)len) * 100.0 / (double)max_size);
                if (curr_pcentprog > old_pcentprog) {
                    console.setProgress(curr_pcentprog);
                }
                old_pcentprog = curr_pcentprog;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

