/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import install.BIRCHIO;
import install.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import wizard.BIRCHWizard;
import wizard.WizardPanel;

public class AdvancedPanel
extends WizardPanel {
    private BIRCHWizard wizard;
    private JLabel installdirLabel = new JLabel("Install directory:");
    private JTextField pathSuffix = new JTextField("BIRCH");
    private JLabel suffixLabel = new JLabel(File.separator);
    private JTextField installDirTextArea = new JTextField(BIRCHIO.DEFAULT_HOME.getAbsolutePath());
    private JTextField installLogText = new JTextField(BIRCHIO.DEFAULT_HOME.getAbsolutePath());
    private JCheckBox miniBirchCheckBox = new JCheckBox("miniBirch");
    private JRadioButton developmentRadioButton = new JRadioButton("Development Version");
    private JCheckBox updateBinaries = new JCheckBox("", true);
    private JLabel updateBinLabel = new JLabel("Update binaries:");
    private JRadioButton releaseRadioButton = new JRadioButton("Current ");
    private JCheckBox linux64CheckBox = new JCheckBox("bin-linux-x86_64");
    private JCheckBox linuxArm64CheckBox = new JCheckBox("bin-linux-arm64");
    private JCheckBox osxCheckBox = new JCheckBox("bin-osx-x86_64");
    private JCheckBox MacosArm64CheckBox = new JCheckBox("bin-macos-arm64");
    private static final long serialVersionUID = 1L;
    private JButton browseButton = new JButton(new AbstractAction("Browse"){
        private long lastcalled;
        {
            this.lastcalled = -1L;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getWhen() != this.lastcalled) {
                JFileChooser fc = new JFileChooser(AdvancedPanel.this.installDirTextArea.getText());
                this.lastcalled = evt.getWhen();
                fc.setFileSelectionMode(1);
                fc.showOpenDialog(null);
                String path = fc.getSelectedFile().getPath();
                AdvancedPanel.this.installDirTextArea.setText(path);
            }
        }
    });
    private JButton logBrowseButton = new JButton(new AbstractAction("Browse"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fc = new JFileChooser(AdvancedPanel.this.installLogText.getText());
            fc.setFileSelectionMode(1);
            fc.showOpenDialog(null);
            String path = fc.getSelectedFile().getPath();
            AdvancedPanel.this.installLogText.setText(path);
        }
    });
    private boolean develOnly = false;
    private JCheckBox SendStatsCheckBox = new JCheckBox("", true);
    private JLabel SendStatsLabel = new JLabel("Send install stats to BIRCH Home:");

    public AdvancedPanel(BIRCHWizard wizard) {
        this.wizard = wizard;
        JPanel contentPanel = new JPanel();
        JLabel logdirLabel = new JLabel("Install/update log directory:");
        JLabel advinstLabel = new JLabel("Advanced Install/update.");
        JLabel frameworkTypeLbl = new JLabel("Framework Type:");
        JLabel autodetectLabel = new JLabel("* - Automatically detected, recommended.");
        JLabel iconLabel = new JLabel(new ImageIcon(AdvancedPanel.class.getResource("dna.jpg")));
        JLabel binariesLabel = new JLabel("Binaries:");
        advinstLabel.setBounds(11, 2, 394, 26);
        this.installdirLabel.setBounds(11, 28, 131, 17);
        this.suffixLabel.setBounds(220, 48, 10, 21);
        this.pathSuffix.setBounds(233, 48, 61, 21);
        this.browseButton.setBounds(312, 45, 98, 23);
        this.installDirTextArea.setBounds(13, 49, 206, 21);
        logdirLabel.setBounds(11, 72, 218, 19);
        this.installLogText.setBounds(12, 91, 290, 20);
        this.logBrowseButton.setBounds(310, 90, 98, 23);
        frameworkTypeLbl.setBounds(11, 115, 127, 21);
        this.miniBirchCheckBox.setBounds(268, 137, 149, 19);
        this.releaseRadioButton.setBounds(13, 140, 214, 16);
        this.developmentRadioButton.setBounds(13, 160, 231, 23);
        binariesLabel.setBounds(18, 190, 132, 18);
        this.linuxArm64CheckBox.setBounds(211, 235, 193, 22);
        this.linux64CheckBox.setBounds(211, 210, 190, 22);
        this.osxCheckBox.setBounds(18, 210, 188, 22);
        this.MacosArm64CheckBox.setBounds(18, 235, 183, 22);
        autodetectLabel.setBounds(22, 286, 312, 20);
        this.updateBinLabel.setBounds(11, 320, 200, 20);
        this.updateBinaries.setBounds(201, 320, 250, 20);
        this.SendStatsLabel.setBounds(11, 345, 365, 20);
        String SendStatsToolTip = "<html>Sends install information to the BIRCH Home site.<br>Only the following data is sent:<br>Date and Time, Version, Platform, New install or Update.<br>These data are important for future funding applications.</html>";
        this.SendStatsCheckBox.setBounds(280, 345, 250, 22);
        this.SendStatsCheckBox.setEnabled(true);
        this.releaseRadioButton.setSelected(true);
        this.installLogText.setEditable(false);
        this.installDirTextArea.setEditable(false);
        this.updateBinLabel.setVisible(false);
        this.updateBinaries.setVisible(false);
        contentPanel.setLayout(null);
        contentPanel.setSize(464, 396);
        contentPanel.add((Component)this.installdirLabel, null);
        contentPanel.add((Component)this.browseButton, null);
        contentPanel.add((Component)this.installDirTextArea, null);
        contentPanel.add((Component)this.suffixLabel, null);
        contentPanel.add((Component)this.pathSuffix, null);
        contentPanel.add((Component)frameworkTypeLbl, null);
        contentPanel.add((Component)this.miniBirchCheckBox, null);
        contentPanel.add((Component)this.developmentRadioButton, null);
        contentPanel.add((Component)binariesLabel, null);
        contentPanel.add((Component)this.linux64CheckBox, null);
        contentPanel.add((Component)this.linuxArm64CheckBox, null);
        contentPanel.add((Component)this.osxCheckBox, null);
        contentPanel.add((Component)this.MacosArm64CheckBox, null);
        contentPanel.add((Component)this.installLogText, null);
        contentPanel.add((Component)this.logBrowseButton, null);
        contentPanel.add((Component)autodetectLabel, null);
        contentPanel.add((Component)this.releaseRadioButton, null);
        contentPanel.add((Component)advinstLabel, null);
        contentPanel.add((Component)logdirLabel, null);
        contentPanel.add((Component)this.updateBinLabel, null);
        contentPanel.add((Component)this.updateBinaries, null);
        contentPanel.add((Component)this.SendStatsLabel, null);
        contentPanel.add((Component)this.SendStatsCheckBox, null);
        ButtonGroup group = new ButtonGroup();
        group.add(this.releaseRadioButton);
        group.add(this.developmentRadioButton);
        iconLabel.setBorder(new EtchedBorder(0));
        contentPanel.setVisible(true);
        contentPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.setLayout(new BorderLayout());
        this.add((Component)iconLabel, "West");
        this.add((Component)contentPanel, "Center");
        switch (Main.PLATFORM) {
            case LINUX_64: {
                this.linux64CheckBox.setSelected(true);
                this.linux64CheckBox.setText(this.linux64CheckBox.getText() + "*");
                break;
            }
            case LINUX_ARM64: {
                this.linuxArm64CheckBox.setSelected(true);
                this.linuxArm64CheckBox.setText(this.linuxArm64CheckBox.getText() + "*");
                break;
            }
            case OSX_64: {
                this.osxCheckBox.setSelected(true);
                this.osxCheckBox.setText(this.osxCheckBox.getText() + "*");
                break;
            }
            case MACOS_ARM64: {
                this.MacosArm64CheckBox.setSelected(true);
                this.MacosArm64CheckBox.setText(this.MacosArm64CheckBox.getText() + "*");
            }
        }
        this.releaseRadioButton.setText(this.releaseRadioButton.getText() + " Version: " + Main.VERSION);
        if (Main.DISC_INSTALL) {
            this.miniBirchCheckBox.setEnabled(false);
            this.developmentRadioButton.setEnabled(false);
        }
    }

    public String getInstallDir() {
        String installDir = "ERROR DETECTING INSTALL/UPDATE DIR!";
        installDir = this.wizard.START_PANEL.isInstall() ? this.installDirTextArea.getText() + File.separator + this.pathSuffix.getText() : this.wizard.START_PANEL.getUpdateDir();
        return installDir;
    }

    public String getFrameworkVersion() {
        String version = Main.VERSION;
        if (this.miniBirchCheckBox.isSelected()) {
            version = version + "M";
        }
        if (this.developmentRadioButton.isSelected()) {
            version = version + "D";
        }
        return version;
    }

    public boolean isDevelopment() {
        return this.develOnly || this.developmentRadioButton.isSelected();
    }

    public String getLogDir() {
        return this.installLogText.getText();
    }

    public Set<Main.ArchSys> getBinariesSelected() {
        EnumSet<Main.ArchSys> binaries = EnumSet.noneOf(Main.ArchSys.class);
        if (this.linux64CheckBox.isSelected()) {
            binaries.add(Main.ArchSys.LINUX_64);
        }
        if (this.linuxArm64CheckBox.isSelected()) {
            binaries.add(Main.ArchSys.LINUX_ARM64);
        }
        if (this.osxCheckBox.isSelected()) {
            binaries.add(Main.ArchSys.OSX_64);
        }
        if (this.MacosArm64CheckBox.isSelected()) {
            binaries.add(Main.ArchSys.MACOS_ARM64);
        }
        return binaries;
    }

    public String getInstallInfo() {
        return "Install/update directory " + this.getInstallDir() + "\nLog File directory" + this.getLogDir() + "\nBinaries:" + this.binariesToString() + "\nVersion: " + this.getFrameworkVersion();
    }

    private String binariesToString() {
        boolean first = true;
        Set<Main.ArchSys> binaries = this.getBinariesSelected();
        StringBuilder binString = new StringBuilder();
        for (Main.ArchSys binary : binaries) {
            if (!first) {
                binString.append(",");
            }
            binString.append((Object)binary);
            first = false;
        }
        return binString.toString();
    }

    public boolean isMiniBIRCH() {
        return this.miniBirchCheckBox.isSelected();
    }

    public boolean doSendStats() {
        return this.SendStatsCheckBox.isSelected();
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public boolean errorCheck() {
        return true;
    }

    public void setInstall(boolean install) {
        this.installDirTextArea.setVisible(install);
        this.pathSuffix.setVisible(install);
        this.installdirLabel.setVisible(install);
        this.suffixLabel.setVisible(install);
        this.browseButton.setVisible(install);
        this.updateBinLabel.setVisible(!install);
        this.updateBinaries.setVisible(!install);
        if (!install && this.wizard.START_PANEL.getUpdateDir().toLowerCase().contains("birchbindev")) {
            this.updateBinaries.setEnabled(false);
            this.updateBinaries.setSelected(false);
        } else {
            this.updateBinaries.setEnabled(true);
        }
    }

    public boolean isKeepBinariesUpdate() {
        return !this.updateBinaries.isSelected();
    }

    public void setDevelopmentOnly(boolean develOnly) {
        this.develOnly = develOnly;
        if (develOnly) {
            this.developmentRadioButton.setSelected(true);
        }
        this.releaseRadioButton.setEnabled(!develOnly);
        this.developmentRadioButton.setEnabled(!develOnly);
    }
}

