/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.BIRCHIO;
import install.Main;
import install.OutputConsole;
import install.Update;
import java.awt.Desktop;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;

public class Install {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installBIRCH(boolean update, File installDir, String frameType, Set<Main.ArchSys> binaries, boolean devel, boolean mini, String adminEmail, boolean createBackup, OutputConsole logger, boolean keep_binaries, boolean stats) {
        long time = System.currentTimeMillis();
        boolean has_depends = true;
        File BIRCHDOC = new File(new File(installDir, "public_html"), "index.html");
        File installScripts = new File(installDir, "install-scripts");
        try {
            PrintStream logstream = logger.getLogStream();
            logger.println("Running GetBIRCH installer process");
            if (update) {
                logger.println("Updating an existing BIRCH installation");
            }
            if (Main.IS_WINDOWS) {
                logger.println("This is a windows install");
            }
            if (!has_depends) {
                logger.println("A required dependancy is not present on system path, BIRCH cannot be installed");
            } else {
                if (update) {
                    logger.println("Updating BIRCH");
                    logger.setProgressTask("Updating BIRCH");
                    logger.println("The selected directory " + installDir + " contains a BIRCH installation, it will be updated");
                    if (createBackup) {
                        try {
                            Update.compress_old_birch(installDir, logger);
                        }
                        catch (IOException ioe) {
                            logger.exception(ioe);
                        }
                    }
                }
                if (update || !Install.clobber_check(installDir, logger)) {
                    logger.println("********************Starting the install process********************");
                    logger.setProgressTask("Starting BIRCH installation process");
                    if (!devel) {
                        logger.println("Installing BIRCH version " + frameType);
                    } else {
                        logger.println("Installing the development version of BIRCH");
                    }
                    logger.println("Using: " + installDir + " as installation directory");
                    if (!installDir.exists()) {
                        logger.println("Creating the install directory: " + installDir);
                        installDir.mkdirs();
                    }
                    File[] filesToExtract = Main.DISC_INSTALL ? Install.disc_prepare(installDir, logger, keep_binaries, update) : Install.download_birch(installDir, frameType, binaries, devel, mini, logger, keep_binaries, update);
                    if (update) {
                        Update.uninstallBIRCH(installDir, logger, keep_binaries);
                    }
                    Install.extract_tarballs(installDir, filesToExtract, logger);
                    String pyexec = Main.IS_WINDOWS ? "python3.exe" : "python3";
                    logger.setProgressTask("Running " + Main.PYTHON_PATH + " birch_install.py...");
                    logger.println("Running " + Main.PYTHON_PATH + " birch_install.py");
                    BIRCHIO.runCommand(new String[]{pyexec, new File(new File(installDir, "install-scripts"), "birch_install.py").getCanonicalPath(), Main.PLATFORM.toString(), installDir.getCanonicalPath(), adminEmail, update ? "N" : "Y", mini ? "Y" : "N", stats ? "Y" : "N"}, null, installDir.getCanonicalFile(), logstream, logstream);
                }
            }
            time = Math.round((double)(System.currentTimeMillis() - time) / 60000.0);
            logger.println("Installation took " + time + " minutes.");
            if (update) {
                logger.println("Update  completed successfully");
                JOptionPane.showMessageDialog(logger, "Update completed successfully!\nClick OK to launch the BIRCH documentation homepage in your browser.\nPlease bookmark the BIRCH documentation page for future reference.");
                JOptionPane.showMessageDialog(logger, "For best results,\nlogout and log back in before using BIRCH.\n");
            } else {
                logger.println("Installation completed successfully");
                JOptionPane.showMessageDialog(logger, "Installation completed successfully!\nClick OK to launch the BIRCH documentation homepage in your browser.\nPlease bookmark the BIRCH documentation page for future reference.");
                JOptionPane.showMessageDialog(logger, "For best results,\nlogout and log back in before using BIRCH.\n");
            }
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(BIRCHDOC.toURI());
            } else {
                BIRCHIO.runCommand(new String[]{Main.PYTHON_PATH, new File(new File(installDir, "script"), "browser.py").getCanonicalPath(), BIRCHDOC.toURI().toURL().toString()}, null, installDir.getCanonicalFile(), logstream, logstream);
            }
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.exception(ex);
            } else {
                ex.printStackTrace(System.err);
            }
            JOptionPane.showMessageDialog(null, "Installation failed, please try again and submit install log as a bug report.");
        }
        finally {
            logger.println("Installation finished");
        }
    }

    public static boolean clobber_check(File installDir, OutputConsole logger) {
        File birchDir;
        boolean clobber = false;
        File localDir = new File(installDir, "local");
        File adminProperties = new File(new File(installDir, "admin"), "BIRCH.properties");
        String birchenv = System.getenv("BIRCH");
        if (installDir.exists()) {
            boolean bl = clobber = localDir.exists() || adminProperties.exists();
            if (clobber) {
                logger.println("ERROR! The directory specified already contains a BIRCH installation! Aborting");
                JOptionPane.showMessageDialog(null, "Installation cancelled to prevent clobbering existing installation.\nPlease restart installer and select a different directory, or remove old installation");
            }
        } else if (birchenv != null && (birchDir = new File(birchenv)).exists()) {
            logger.println("An existing BIRCH installation was found at: \"" + birchDir.getAbsolutePath() + "\"");
            if (installDir.equals(birchDir)) {
                int reload = JOptionPane.showConfirmDialog(null, "The installation directory that you specified:\n" + installDir + "\nAlready contains a BIRCH installation. Are you sure you wish to proceed?(NOT recommended)", "Input", 0);
                boolean bl = clobber = reload == 1;
                if (clobber) {
                    logger.println("User aborted install.");
                } else {
                    logger.println("User decided to install over old installation.");
                }
            }
        }
        return clobber;
    }

    private static File[] disc_prepare(File installDir, OutputConsole logger, boolean keep_binaries, boolean update) throws IOException {
        File framework_src = new File(BIRCHIO.JAR_PATH, "framework.tar.gz");
        File binaries_src = new File(BIRCHIO.JAR_PATH, "binaries.tar.gz");
        File framework_dest = new File(installDir, "framework.tar.gz");
        File binaries_dest = new File(installDir, "binaries.tar.gz");
        PrintStream logstream = logger.getLogStream();
        logger.println("This is a disc install, must decompress binaries to install directory");
        logger.setProgressTask("Copying framework to installation directory");
        logger.println("Copying framework to installation directory...");
        BIRCHIO.copy(framework_dest, framework_src, logger, true);
        logger.println("Decompressing framework...");
        logger.setProgressTask("Decompressing framework...");
        if (!keep_binaries) {
            logger.setProgressTask("Copying binaries to installation directory");
            logger.println("Copying binaries to installation directory...");
            BIRCHIO.copy(binaries_dest, binaries_src, logger, true);
        }
        return new File[]{framework_dest, binaries_dest};
    }

    private static File[] download_birch(File installDir, String version, Set<Main.ArchSys> binaries, boolean development, boolean minibirch, OutputConsole logger, boolean keep_binaries, boolean update) throws IOException {
        URL framework = null;
        File framework_tar = File.createTempFile("framework", ".tar.gz", installDir);
        ArrayList<File> files = new ArrayList<File>();
        framework_tar.deleteOnExit();
        logger.println("********************Fetching archives********************");
        if (!minibirch && !development) {
            framework = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/CURRENT/framework_" + version + ".tar.gz");
            logger.println("Downloading BIRCH framework to " + installDir + " from " + framework);
        } else if (minibirch && !development) {
            framework = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/minibirch/framework.mini_" + version + ".tar.gz");
            logger.println("Downloading miniBirch framework to " + installDir + " from " + framework);
        } else if (!minibirch && development) {
            framework = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/Development/framework_D.tar.gz");
            logger.println("Downloading development framework to " + installDir + " from " + framework);
        } else {
            framework = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/minibirch/framework.mini_D.tar.gz");
            logger.println("Downloading miniBirch development framework to " + installDir + " from " + framework);
        }
        logger.setProgressTask("Downloading framework");
        BIRCHIO.wget(framework, framework_tar, logger, true);
        files.add(framework_tar);
        if (!keep_binaries) {
            for (Main.ArchSys platform : binaries) {
                URL location = null;
                File binfile = File.createTempFile(platform.toString(), ".tar.gz", installDir);
                binfile.deleteOnExit();
                location = development ? new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/Development/bin-" + (Object)((Object)platform) + "_D.tar.gz") : new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/CURRENT/bin-" + (Object)((Object)platform) + "_" + version + ".tar.gz");
                logger.println("Downloading binaries for platform \"" + (Object)((Object)platform) + "\" to " + installDir + " from " + location);
                logger.setProgressTask("Downloading binaries (" + (Object)((Object)platform) + ")");
                BIRCHIO.wget(location, binfile, logger, true);
                files.add(binfile);
            }
        }
        return files.toArray(new File[0]);
    }

    private static void extract_tarballs(File installDir, File[] files, OutputConsole logger) throws IOException {
        PrintStream logstream = logger.getLogStream();
        for (File f : files) {
            logger.println("Decompressing " + f + "...");
            logger.setProgressTask("Decompressing framework...");
            if (f.exists()) {
                BIRCHIO.untar(f, installDir, logstream, logstream, true);
                continue;
            }
            logger.println("The required file framework.tar.gz was not found");
        }
    }

    private static void SendStatsToBirch(boolean devel, String platform, boolean update) {
        String STAT_URL_BASE = "http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi";
        String version = devel ? "D" : Main.VERSION;
        String insttype = update ? "update" : "new";
        String Params = "?version=" + version + "&platform=" + platform + "&insttype=" + insttype;
        try {
            URL CGIurl = new URL("http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
            URLConnection c = null;
            try {
                c = CGIurl.openConnection();
                System.out.println("Opened connection to http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
            }
            catch (Exception Eopen) {
                System.out.println(">>> Cannot open connection to http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
            }
            c.setDoOutput(true);
            c.setUseCaches(false);
            c.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(c.getOutputStream());
            try {
                out.writeBytes(Params);
                out.flush();
                out.close();
                System.out.println("Wrote data to http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
                System.out.println(Params);
            }
            catch (Exception Ewrite) {
                System.out.println(">>> Cannot write to http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
            }
        }
        catch (Exception ex) {
            System.out.println(">>> Cannot send stats to http://brassica.plants.umanitoba.ca/cgi-bin/birch/birchtally.cgi");
        }
    }
}

