/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.BIRCHIO;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import wizard.BIRCHWizard;

public class Main {
    public static final String BASE_URL = "https://ftp.cc.umanitoba.ca/psgendb/BIRCH/";
    public static final SimpleDateFormat TSTAMP_FMT = new SimpleDateFormat("EE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
    public static final boolean IS_WINDOWS = System.getProperty("os.name").trim().toLowerCase().startsWith("win");
    public static final String JAVA_EXEC = Main.get_java_exec();
    public static final ArchSys PLATFORM = Main.detect_platform();
    public static final String VERSION = Main.detect_version();
    public static final Date TIMESTAMP = Main.detect_timestamp();
    public static final boolean DISC_INSTALL = Main.is_disc_install();
    public static final String PYTHON_PATH = Main.find_python();
    public static File WIN_TAR = null;
    public static File WIN_GZ = null;

    public static void main(String[] args) {
        if (PYTHON_PATH != null) {
            if (!DISC_INSTALL) {
                Main.extractLib();
            }
            BIRCHWizard bIRCHWizard = new BIRCHWizard();
        }
    }

    private static boolean is_disc_install() {
        File LIB = new File(BIRCHIO.JAR_PATH, "getbirch_temp");
        File BIN = new File(BIRCHIO.JAR_PATH, "binaries.tar.gz");
        File FRAME = new File(BIRCHIO.JAR_PATH, "framework.tar.gz");
        boolean isDisc = false;
        if (BIRCHIO.JAR_PATH.isDirectory()) {
            isDisc = LIB.exists() && BIN.exists() && FRAME.exists();
        } else {
            JOptionPane.showMessageDialog(null, "Not current directory:" + BIRCHIO.JAR_PATH);
        }
        return isDisc;
    }

    private static ArchSys detect_platform() {
        String osName = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        ArchSys result = ArchSys.LINUX_64;
        if (IS_WINDOWS) {
            result = ArchSys.WINXP_32;
        } else if (osName.startsWith("mac")) {
            result = arch.equals("aarch64") ? ArchSys.MACOS_ARM64 : ArchSys.OSX_64;
        } else if (osName.startsWith("linux")) {
            result = arch.equals("aarch64") ? ArchSys.LINUX_ARM64 : ArchSys.LINUX_64;
        } else {
            try {
                File linux64path = BIRCHIO.extract_temp("/resources/probe_linux64.so", "linux_64", ".so");
                System.load(linux64path.getAbsolutePath());
                if (Main.probe_linux64()) {
                    result = ArchSys.LINUX_64;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        System.out.println("Setting platform to \"" + (Object)((Object)result) + "\" ");
        return result;
    }

    private static native boolean probe_linux64();

    private static String detect_version() {
        String VERSION_URL = "https://ftp.cc.umanitoba.ca/psgendb/BIRCH/CURRENT/VERSION";
        String versionStr = "";
        try {
            versionStr = BIRCHIO.oneLineFile(new URL(VERSION_URL));
            System.out.println("BIRCH version " + versionStr);
        }
        catch (IOException ioe) {
            System.err.println("Could not detect the current version of BIRCH!");
            ioe.printStackTrace(System.err);
        }
        return versionStr;
    }

    private static Date detect_timestamp() {
        String TIMESTAMP_URL = "https://ftp.cc.umanitoba.ca/psgendb/BIRCH/CURRENT/TIMESTAMP";
        String timestampStr = "";
        Date tstamp = null;
        try {
            timestampStr = BIRCHIO.oneLineFile(new URL(TIMESTAMP_URL));
            tstamp = TSTAMP_FMT.parse(timestampStr);
            System.out.println("BIRCH timestamp " + TSTAMP_FMT.format(tstamp));
        }
        catch (IOException ioe) {
            System.err.println("Could not detect the current timetamp of BIRCH!");
            ioe.printStackTrace(System.err);
        }
        catch (ParseException pe) {
            System.err.println("Could not parse the current timetamp of BIRCH!");
            System.out.println("String: " + timestampStr);
            pe.printStackTrace(System.err);
        }
        return tstamp;
    }

    private static String get_java_exec() {
        File javaBin = new File(System.getProperty("java.home"), "bin");
        File winJava = new File(javaBin, "javaw.exe");
        File unxJava = new File(javaBin, "java");
        return IS_WINDOWS ? winJava.getAbsolutePath() : unxJava.getAbsolutePath();
    }

    public static void extractLib() {
        if (IS_WINDOWS) {
            WIN_TAR = BIRCHIO.extract_temp("/resources/tar.exe", "tar", ".exe");
            WIN_GZ = BIRCHIO.extract_temp("/resources/gunzip.exe", "gunzip", ".exe");
        }
    }

    public static void cancel() {
        JOptionPane.showMessageDialog(null, "Installation cancelled.");
        System.out.println("Installation cancelled!");
        System.exit(0);
    }

    public static String find_python() {
        String[] PATH;
        String pypath = null;
        String pyexec = IS_WINDOWS ? "python3.exe" : "python3";
        for (String testString : PATH = System.getenv("PATH").split(File.pathSeparator)) {
            File test = new File(testString, pyexec);
            if (!test.exists()) continue;
            try {
                pypath = test.getCanonicalPath();
                break;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (pypath == null && IS_WINDOWS) {
            File pytest = new File("C:\\Python\\python3.exe");
            if (pytest.exists() && pytest.isFile() && pytest.canExecute()) {
                try {
                    pypath = pytest.getCanonicalPath();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            } else {
                pytest = new File("C:\\Program Files\\Python\\python3.exe");
                if (pytest.exists() && pytest.isFile() && pytest.canExecute()) {
                    try {
                        pypath = pytest.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                } else {
                    int selection = JOptionPane.showOptionDialog(null, "ERROR -- could not find Python!\nWould you like to install Python or help GetBIRCH find python3.exe?", "GetBIRCH", 1, 3, null, new Object[]{"Install", "Find", "Cancel"}, 0);
                    if (selection == 0) {
                        JFileChooser fc = new JFileChooser(BIRCHIO.DEFAULT_HOME);
                        fc.setDialogTitle("Choose a directory to install Python");
                        fc.setFileSelectionMode(1);
                        fc.showOpenDialog(null);
                        File pydir = fc.getSelectedFile();
                        if (pydir != null) {
                            try {
                                pypath = Main.win_install_python(new File(pydir, "Python"));
                            }
                            catch (MalformedURLException ex) {
                                ex.printStackTrace(System.err);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    } else if (selection == 1) {
                        JFileChooser fc = new JFileChooser(BIRCHIO.DEFAULT_HOME);
                        fc.setDialogTitle("Find python3.exe");
                        fc.setFileSelectionMode(1);
                        fc.showOpenDialog(null);
                        pytest = new File(fc.getSelectedFile(), "python3.exe");
                        if (pytest.exists() && pytest.isFile() && pytest.canExecute()) {
                            try {
                                pypath = pytest.getCanonicalPath();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    }
                }
            }
        }
        return pypath;
    }

    public static String win_install_python(File pydir) throws MalformedURLException, IOException {
        URL pyurl = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/pyinstall.msi");
        File pymsi = File.createTempFile("pyinstall", ".msi");
        System.out.println("Downloading Python: " + pyurl.toString());
        BIRCHIO.wget(pyurl, pymsi, null, true);
        BIRCHIO.runCommand(new String[]{"msiexec", "/i", pymsi.getCanonicalPath(), "TARGETDIR=" + pydir.getCanonicalPath(), "/qb!"}, null, pymsi.getParentFile(), System.out, System.err);
        return new File(new File(pydir, "bin"), "python3.exe").getCanonicalPath();
    }

    private static boolean csh_ok() {
        File csh_test = new File("/bin/csh");
        return csh_test.exists() && csh_test.isFile() && csh_test.canExecute() || JOptionPane.showConfirmDialog(null, "Error: could not find /bin/csh, do you want to proceed anyways?", "GetBIRCH", 0) == 0;
    }

    public static enum ArchSys {
        LINUX_64("linux-x86_64"),
        LINUX_ARM64("linux-arm64"),
        OSX_64("osx-x86_64"),
        MACOS_ARM64("macos-arm64"),
        WINXP_32("winxp-32");

        private String name;

        private ArchSys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

