/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.Main;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OutputConsole
extends JFrame {
    private JTextArea textConsole = new JTextArea(){
        {
            this.setEditable(false);
        }
    };
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private JScrollPane scrollpane = new JScrollPane(this.textConsole, 22, 32);
    private static final long serialVersionUID = 1L;
    private String task = "";
    private boolean finished = false;
    private final WindowListener CLOSE_WINDOW = new WindowAdapter(){

        @Override
        public synchronized void windowClosing(WindowEvent arg0) {
            if (!OutputConsole.this.finished) {
                Main.cancel();
            } else {
                System.exit(0);
            }
        }
    };
    private PrintWriter logwriter;
    private OutputStream logstream;

    public OutputConsole(final OutputStream logstream) {
        super("Getbirch BIRCH Installer Console");
        this.logwriter = new PrintWriter(logstream);
        this.logstream = logstream;
        System.out.println("Starting output console");
        JPanel mainPane = new JPanel();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(true);
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.scrollpane, "Center");
        mainPane.add((Component)this.progressBar, "South");
        this.setSize(475, 257);
        this.add(mainPane);
        this.addWindowListener(this.CLOSE_WINDOW);
        this.doLayout();
        this.validate();
        this.repaint(50L);
        this.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                OutputConsole.this.logwriter.flush();
                try {
                    logstream.flush();
                    logstream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
        }));
    }

    public synchronized void println(String line) {
        this.textConsole.append(line);
        this.textConsole.append("\n");
        this.logwriter.println(line);
        this.logwriter.flush();
        System.out.println(line);
    }

    public void exception(Throwable th) {
        th.printStackTrace(this.logwriter);
        th.printStackTrace(System.err);
    }

    public PrintStream getLogStream() throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        final BufferedReader in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        OutputConsole.this.println(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
        return new PrintStream(out);
    }

    public synchronized void setProgress(int progress) {
        this.progressBar.setValue(progress);
        this.progressBar.setString(this.task + " - " + progress + "%");
    }

    public synchronized void setIndeterminate(boolean isIndeterminate) {
        this.progressBar.setIndeterminate(isIndeterminate);
    }

    public synchronized void setProgressTask(String task) {
        this.task = task;
        this.progressBar.setString(task);
    }

    public synchronized void finished() {
        this.finished = true;
        this.progressBar.setVisible(false);
    }
}

