/*
 * Decompiled with CFR 0.152.
 */
package install;

import install.BIRCHIO;
import install.Main;
import install.OutputConsole;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import wizard.BIRCHWizard;

public class Update {
    public static final String[] birch_files = new String[]{"local-generic", "labace", "script", "install-birch", "bin-linux-intel", "bin-linux-x86_64", "bin-solaris-sparc", "bin-solaris-amd64", "bin-osx-x86_64", "dat", "admin.uninstall", "doc", "pkg", "java", "public_html", "manl", "birchconfig.homedir.target.html", "tutorials", "lib-linux-intel", "lib-linux-x86_64", "lib-solaris-sparc", "lib-solaris-amd64", "lib-osx-x86_64", "admin"};

    public static void compress_old_birch(File installDir, OutputConsole logger) throws IOException {
        logger.println("********************Archiving old BIRCH********************");
        logger.setProgressTask("Archiving old BIRCH");
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        File tfile = new File(installDir, "birch_backup-" + dateFormat.format(date) + ".tar");
        PrintStream logstream = logger.getLogStream();
        for (String each : birch_files) {
            File backup = new File(installDir, each);
            if (!backup.exists()) continue;
            logger.println("Archiving old birch directory " + each);
            BIRCHIO.add_tar(tfile, backup, logstream, logstream);
        }
    }

    public static boolean check_version(File birch_path, BIRCHWizard wizard) {
        boolean version_ok = true;
        if (birch_path != null) {
            File install_birch = new File(birch_path, "install-birch");
            File birch_version = new File(install_birch, "BIRCH.version");
            File birch_tstamp = new File(install_birch, "BIRCH.version.timestamp");
            try {
                if (birch_version.exists() && birch_version.isFile() && birch_version.canRead()) {
                    String versionStr = BIRCHIO.oneLineFile(birch_version.toURI().toURL());
                    if ("D".equalsIgnoreCase(versionStr)) {
                        Date timestamp;
                        if (birch_tstamp.exists() && birch_tstamp.isFile() && birch_tstamp.canRead() && Main.TIMESTAMP.before(timestamp = Main.TSTAMP_FMT.parse(BIRCHIO.oneLineFile(birch_tstamp.toURI().toURL())))) {
                            JOptionPane.showMessageDialog(null, "Note: the version of BIRCH currently installed is newer than the most stable version.\nYou may only update to another development version of BIRCH!");
                            wizard.ADVANCED_PANEL.setDevelopmentOnly(true);
                        }
                    } else if (Main.VERSION.equalsIgnoreCase(versionStr)) {
                        version_ok = JOptionPane.showConfirmDialog(null, "The most recent version of BIRCH is the same as the\none installed on your computer.  Updating BIRCH to the\nsame version may be used to fix problems that happened\nafter installation.  Are you sure you sure that you wish\n to \"reinstall to the same version?\n\n(all of your post installation preferences should be preserved)", "GetBIRCH", 0) == 0;
                    }
                }
            }
            catch (Exception ex) {
                version_ok = JOptionPane.showConfirmDialog(null, "An error occurred while reading the version of the directory to update.\nDo you wish to proceed anyways with updating BIRCH?", "GetBIRCH", 0) == 0;
                ex.printStackTrace(System.err);
            }
        }
        return version_ok;
    }

    public static boolean is_valid_birch(File installDir) {
        boolean ok = false;
        if (installDir != null) {
            File installBIRCH = new File(installDir, "install-birch");
            File installScripts = new File(installDir, "install-scripts");
            File localDir = new File(installDir, "local");
            ok = installDir.exists() && installDir.isDirectory() && localDir.exists() && localDir.isDirectory();
        }
        return ok;
    }

    public static void uninstallBIRCH(File installDir, OutputConsole logger, boolean keep_binaries) throws IOException {
        File installBIRCH = new File(installDir, "install-birch");
        File installScripts = new File(installDir, "install-scripts");
        File shellUninstall = new File(installBIRCH, "UNINSTALL-birch.sh");
        File pythonUninstall = new File(installScripts, "UNINSTALL-birch.py");
        PrintStream logstream = logger.getLogStream();
        URL location = new URL("https://ftp.cc.umanitoba.ca/psgendb/BIRCH/CURRENT/UNINSTALL-birch.py");
        if (!installScripts.exists() && installBIRCH.exists() && shellUninstall.exists()) {
            BIRCHIO.runCommand(new String[]{"/bin/sh", "-f", shellUninstall.getCanonicalPath(), "-Q", keep_binaries ? "-n" : ""}, null, installDir, logstream, logstream);
        } else {
            pythonUninstall = File.createTempFile("UNINSTALL-birch", ".py", installDir);
            BIRCHIO.wget(location, pythonUninstall, logger, true);
            pythonUninstall.deleteOnExit();
            BIRCHIO.runCommand(new String[]{Main.PYTHON_PATH, pythonUninstall.getCanonicalPath(), "-Q", "-d=" + installDir.getCanonicalPath(), keep_binaries ? "-n" : ""}, null, installDir, logstream, logstream);
        }
    }
}

