/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import install.Install;
import install.Main;
import install.OutputConsole;
import install.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import wizard.AdvancedPanel;
import wizard.StartPanel;
import wizard.TypePanel;
import wizard.WizardPanel;

public class BIRCHWizard
extends JFrame {
    public static final Icon BACK_ICON = new ImageIcon(BIRCHWizard.class.getResource("backIcon.gif"));
    public static final Icon NEXT_ICON = new ImageIcon(BIRCHWizard.class.getResource("nextIcon.gif"));
    public static final Icon FINISH_ICON = new ImageIcon(BIRCHWizard.class.getResource("finishIcon.gif"));
    public static final Icon CANCEL_ICON = new ImageIcon(BIRCHWizard.class.getResource("cancelIcon.gif"));
    public final ActionListener changeNextToFinishAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BIRCHWizard.this.setFinish(true);
        }
    };
    public final ActionListener changeFinishToNextAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BIRCHWizard.this.setFinish(false);
        }
    };
    public final StartPanel START_PANEL = new StartPanel(this);
    public final TypePanel TYPE_PANEL = new TypePanel(this);
    public final AdvancedPanel ADVANCED_PANEL = new AdvancedPanel(this);
    private JPanel cardPanel = new JPanel();
    private int currentPanel = 0;
    private final WizardPanel[] panels = new WizardPanel[]{this.START_PANEL, this.TYPE_PANEL, this.ADVANCED_PANEL};
    private boolean finish = false;
    private JButton backButton = new JButton(new AbstractAction("Back", BACK_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BIRCHWizard.this.currentPanel > 0) {
                BIRCHWizard.this.currentPanel--;
                BIRCHWizard.this.cardPanel.removeAll();
                BIRCHWizard.this.cardPanel.add((Component)BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel], "CURRENT_PANEL" + BIRCHWizard.this.currentPanel);
                BIRCHWizard.this.cardPanel.setSize(BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel].getSize());
                BIRCHWizard.this.cardPanel.setPreferredSize(BIRCHWizard.this.cardPanel.getSize());
                BIRCHWizard.this.cardPanel.doLayout();
                BIRCHWizard.this.cardPanel.validate();
                BIRCHWizard.this.cardPanel.repaint(50L);
            }
            BIRCHWizard.this.backButton.setEnabled(BIRCHWizard.this.currentPanel > 0);
            BIRCHWizard.this.setFinish(BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel].isFinished());
        }
    }){
        {
            this.setEnabled(false);
        }
    };
    private JButton nextButton = new JButton(new AbstractAction("Next", NEXT_ICON){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel].errorCheck()) {
                BIRCHWizard.this.currentPanel++;
                if (BIRCHWizard.this.currentPanel < BIRCHWizard.this.panels.length && !BIRCHWizard.this.finish) {
                    BIRCHWizard.this.cardPanel.removeAll();
                    BIRCHWizard.this.cardPanel.add((Component)BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel], "CURRENT_PANEL" + BIRCHWizard.this.currentPanel);
                    BIRCHWizard.this.cardPanel.setSize(BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel].getSize());
                    BIRCHWizard.this.cardPanel.setPreferredSize(BIRCHWizard.this.cardPanel.getSize());
                    BIRCHWizard.this.cardPanel.doLayout();
                    BIRCHWizard.this.cardPanel.validate();
                    BIRCHWizard.this.cardPanel.repaint(50L);
                    BIRCHWizard.this.backButton.setEnabled(true);
                    BIRCHWizard.this.TYPE_PANEL.installStatus.setText(BIRCHWizard.this.ADVANCED_PANEL.getInstallInfo());
                    BIRCHWizard.this.setFinish(BIRCHWizard.this.panels[BIRCHWizard.this.currentPanel].isFinished());
                } else {
                    File logDir = new File(BIRCHWizard.this.ADVANCED_PANEL.getLogDir());
                    FileOutputStream logger = null;
                    if (logDir != null) {
                        File logfile = new File(logDir, "getbirch.log");
                        try {
                            if (logfile.exists() && logfile.canWrite() || logfile.createNewFile()) {
                                logger = new FileOutputStream(logfile);
                            } else {
                                System.err.println("ERROR CREATING LOG FILE!");
                                System.exit(0);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace(System.err);
                            System.err.println("ERROR CREATING LOG FILE!");
                            System.exit(0);
                        }
                    }
                    final OutputConsole console = new OutputConsole(logger);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String adminEmail;
                            boolean install = BIRCHWizard.this.START_PANEL.isInstall();
                            boolean advanced = BIRCHWizard.this.TYPE_PANEL.isAdvancedInstall();
                            boolean createBackup = BIRCHWizard.this.START_PANEL.makeBackup();
                            boolean devel = BIRCHWizard.this.ADVANCED_PANEL.isDevelopment();
                            boolean mini = BIRCHWizard.this.ADVANCED_PANEL.isMiniBIRCH();
                            String frameType = BIRCHWizard.this.ADVANCED_PANEL.getFrameworkVersion();
                            Set<Main.ArchSys> binaries = BIRCHWizard.this.ADVANCED_PANEL.getBinariesSelected();
                            boolean keep_binaries = !BIRCHWizard.this.START_PANEL.isInstall() && (BIRCHWizard.this.ADVANCED_PANEL.isKeepBinariesUpdate() || BIRCHWizard.this.START_PANEL.getUpdateDir().toLowerCase().contains("birchbindev"));
                            boolean stats = BIRCHWizard.this.ADVANCED_PANEL.doSendStats();
                            File installDir = new File(BIRCHWizard.this.ADVANCED_PANEL.getInstallDir());
                            if (install) {
                                adminEmail = BIRCHWizard.this.START_PANEL.getEmail();
                            } else {
                                adminEmail = "to@be.replaced";
                                console.println("TODO: EMAIL ADDRESS OBTAINED FROM BIRCH PROPERTIES");
                                while (installDir != null && !Update.is_valid_birch(installDir)) {
                                    console.println("The selected directory " + installDir + " does NOT contain a BIRCH installation!");
                                    if (JOptionPane.showConfirmDialog(null, "The selected path does NOT contain a BIRCH installation.\nPlease select the base directory of the installation that you wish to update,\nOr click \"no\" to cancel update.", "GetBIRCH", 0) == 1) {
                                        console.println("User aborted install.");
                                        System.exit(1);
                                        continue;
                                    }
                                    JFileChooser fc = new JFileChooser(installDir);
                                    fc.setFileSelectionMode(1);
                                    fc.showOpenDialog(null);
                                    installDir = fc.getSelectedFile();
                                }
                            }
                            if (advanced) {
                                System.out.println("Proceeding with default install");
                            } else {
                                System.out.println("An advanced install was selected");
                            }
                            Install.installBIRCH(!install, installDir, frameType, binaries, devel, mini, adminEmail, createBackup, console, keep_binaries, stats);
                            console.finished();
                        }
                    }).start();
                    BIRCHWizard.this.dispose();
                }
            }
        }
    });
    private JButton cancelButton = new JButton(new AbstractAction("Cancel", CANCEL_ICON){

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            Main.cancel();
        }
    });

    public BIRCHWizard() {
        super("GetBIRCH BIRCH Install Wizard");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardPanel.setLayout(new CardLayout());
        this.cardPanel.add((Component)this.START_PANEL, "START_PANEL");
        this.cardPanel.setSize(this.START_PANEL.getSize());
        this.cardPanel.setPreferredSize(this.START_PANEL.getSize());
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)new JScrollPane(this.cardPanel, 20, 30), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public synchronized void windowClosing(WindowEvent arg0) {
                Main.cancel();
            }
        });
        this.pack();
        this.setSize(650, 475);
        this.setVisible(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    private void setFinish(boolean finish) {
        this.finish = finish;
        if (finish) {
            this.nextButton.setText("Finish");
            this.nextButton.setIcon(FINISH_ICON);
        } else {
            this.nextButton.setText("Next");
            this.nextButton.setIcon(NEXT_ICON);
        }
    }
}

