/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import install.BIRCHIO;
import install.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import wizard.BIRCHWizard;
import wizard.WizardPanel;

public class StartPanel
extends WizardPanel {
    private BIRCHWizard wizard;
    private JRadioButton newInstallButton = new JRadioButton(new AbstractAction("Create a new installation"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            StartPanel.this.updateDirectoryText.setEnabled(false);
            StartPanel.this.updateDirectoryButton.setEnabled(false);
            StartPanel.this.backupBirch.setEnabled(false);
            ((StartPanel)StartPanel.this).wizard.ADVANCED_PANEL.setInstall(true);
            StartPanel.this.adminEmailText.setEditable(true);
        }
    });
    private JRadioButton updateButton = new JRadioButton(new AbstractAction("Update an existing installation"){

        @Override
        public void actionPerformed(ActionEvent e) {
            File path = null;
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.showOpenDialog(null);
            path = fc.getSelectedFile();
            ((StartPanel)StartPanel.this).wizard.ADVANCED_PANEL.setDevelopmentOnly(false);
            if (path != null && Update.check_version(path, StartPanel.this.wizard) && !path.getPath().contains("BIRCHDEV")) {
                StartPanel.this.updateDirectoryText.setText(path.getPath());
                StartPanel.this.updateDirectoryText.setEnabled(true);
                StartPanel.this.updateDirectoryButton.setEnabled(true);
                StartPanel.this.backupBirch.setEnabled(true);
                ((StartPanel)StartPanel.this).wizard.ADVANCED_PANEL.setInstall(false);
                StartPanel.this.adminEmailText.setEditable(false);
            } else {
                StartPanel.this.newInstallButton.setSelected(true);
                ((StartPanel)StartPanel.this).wizard.ADVANCED_PANEL.setInstall(true);
                StartPanel.this.adminEmailText.setEditable(true);
            }
        }
    });
    private JTextField updateDirectoryText = new JTextField(BIRCHIO.DEFAULT_HOME.getAbsolutePath());
    private JCheckBox backupBirch = new JCheckBox("Create a backup of existing install");
    private JTextField adminEmailText = new JTextField("Enter BIRCH Administrator's email");
    private static final long serialVersionUID = 1L;
    private JButton updateDirectoryButton = new JButton(new AbstractAction("Browse"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            File path = null;
            JFileChooser fc = new JFileChooser(StartPanel.this.updateDirectoryText.getText());
            fc.setFileSelectionMode(1);
            fc.showOpenDialog(null);
            path = fc.getSelectedFile();
            if (path != null) {
                StartPanel.this.updateDirectoryText.setText(path.getPath());
            }
        }
    });

    public StartPanel(BIRCHWizard wizard) {
        this.wizard = wizard;
        JLabel welcomeLabel = new JLabel("Welcome to the GetBIRCH BIRCH installer.");
        JLabel createInstallLabel = new JLabel("Create a new installation:");
        JLabel updateLabel = new JLabel("Update an existing installation:");
        JLabel iconLabel = new JLabel(new ImageIcon(StartPanel.class.getResource("dna.jpg")));
        JLabel emailLabel = new JLabel("Email:");
        JPanel contentPanel = new JPanel();
        ButtonGroup bgroup = null;
        JTextArea jTextArea = new JTextArea("This will allow you to set up a new BIRCH installation, \neither from network or from an install disc.");
        JTextArea jTextArea1 = new JTextArea("Update to the latest release.");
        createInstallLabel.setBounds(4, 45, 472, 30);
        welcomeLabel.setBounds(4, 15, 476, 27);
        this.newInstallButton.setBounds(4, 85, 370, 17);
        jTextArea.setBounds(19, 105, 473, 36);
        emailLabel.setBounds(16, 144, 75, 26);
        this.adminEmailText.setBounds(103, 145, 273, 24);
        updateLabel.setBounds(4, 185, 473, 26);
        this.updateButton.setBounds(4, 220, 368, 17);
        jTextArea1.setBounds(17, 238, 473, 34);
        this.backupBirch.setBounds(30, 276, 338, 21);
        this.updateDirectoryText.setBounds(30, 310, 350, 20);
        this.updateDirectoryButton.setBounds(387, 310, 98, 23);
        this.updateDirectoryText.setEnabled(false);
        this.updateDirectoryText.setEditable(false);
        this.updateDirectoryButton.setEnabled(false);
        this.backupBirch.setSelected(false);
        this.backupBirch.setEnabled(this.updateButton.isSelected());
        jTextArea.setEditable(false);
        jTextArea1.setEditable(false);
        contentPanel.setLayout(null);
        contentPanel.setSize(512, 344);
        contentPanel.add((Component)this.newInstallButton, null);
        contentPanel.add((Component)this.updateButton, null);
        contentPanel.add((Component)this.updateDirectoryText, null);
        contentPanel.add((Component)this.updateDirectoryButton, null);
        contentPanel.add((Component)welcomeLabel, null);
        contentPanel.add((Component)createInstallLabel, null);
        contentPanel.add((Component)jTextArea, null);
        contentPanel.add((Component)updateLabel, null);
        contentPanel.add((Component)jTextArea1, null);
        contentPanel.add((Component)this.backupBirch, null);
        contentPanel.add((Component)this.adminEmailText, null);
        contentPanel.add((Component)emailLabel, null);
        bgroup = new ButtonGroup();
        bgroup.add(this.newInstallButton);
        bgroup.add(this.updateButton);
        contentPanel.setVisible(true);
        contentPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.setLayout(new BorderLayout());
        iconLabel.setBorder(new EtchedBorder(0));
        this.add((Component)iconLabel, "West");
        this.add((Component)contentPanel, "Center");
        this.updateDirectoryText.setEnabled(this.updateButton.isSelected());
        this.updateDirectoryButton.setEnabled(this.updateButton.isSelected());
        this.newInstallButton.setSelected(true);
        this.updateDirectoryButton.addActionListener(wizard.changeNextToFinishAction);
    }

    public boolean makeBackup() {
        return this.backupBirch.isSelected();
    }

    public boolean isInstall() {
        return this.newInstallButton.isSelected();
    }

    public String getUpdateDir() {
        String dir = null;
        if (this.updateButton.isSelected()) {
            dir = this.updateDirectoryText.getText();
        }
        return dir;
    }

    public String getEmail() {
        return this.adminEmailText.getText();
    }

    public boolean validateEmail() {
        String email = this.getEmail();
        Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
        Matcher m = p.matcher(email);
        boolean matchFound = m.matches();
        return matchFound;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public boolean errorCheck() {
        boolean email_ok;
        boolean bl = email_ok = !this.isInstall() || this.validateEmail();
        if (!email_ok) {
            JOptionPane.showMessageDialog(this.wizard, "ERROR -- you must enter a valid email address for the BIRCH administrator");
            this.adminEmailText.requestFocusInWindow();
        }
        return email_ok;
    }
}

