/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2017 UniPro <ugene@unipro.ru>
 * http://ugene.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef _U2_ABSTRACT_PROJECT_FILTER_TASK_H_
#define _U2_ABSTRACT_PROJECT_FILTER_TASK_H_

#include <U2Core/DocumentModel.h>
#include <U2Core/ProjectTreeControllerModeSettings.h>
#include <U2Core/Task.h>

namespace U2 {

typedef QList<QPointer<GObject> > SafeObjList;

//////////////////////////////////////////////////////////////////////////
/// AbstractProjectFilterTask
//////////////////////////////////////////////////////////////////////////

class U2CORE_EXPORT AbstractProjectFilterTask : public Task {
    Q_OBJECT
public:
    void run();

signals:
    void si_objectsFiltered(const QString &filterGroupName, const SafeObjList &objects);

protected:
    AbstractProjectFilterTask(const ProjectTreeControllerModeSettings &settings, const QString &filterGroupName,
        const QList<QPointer<Document> > &docs);

    virtual bool filterAcceptsObject(GObject *obj);

    const ProjectTreeControllerModeSettings settings;
    const QList<QPointer<Document> > docs;
    const QString filterGroupName;
    SafeObjList filteredObjs;

    int filteredObjCountPerIteration;
    int totalObjectCount;
    int processedObjectCount;

private:
    void filterDocument(const QPointer<Document> &doc);

    static void doStaticInitialization();
};

//////////////////////////////////////////////////////////////////////////
/// ProjectFilterTaskFactory
//////////////////////////////////////////////////////////////////////////

class U2CORE_EXPORT ProjectFilterTaskFactory {
public:
    virtual ~ProjectFilterTaskFactory();

    AbstractProjectFilterTask * registerNewTask(const ProjectTreeControllerModeSettings &settings, const QList<QPointer<Document> > &docs) const;

protected:
    virtual AbstractProjectFilterTask * createNewTask(const ProjectTreeControllerModeSettings &settings,
        const QList<QPointer<Document> > &docs) const = 0;
};

} // namespace U2

#endif // _U2_ABSTRACT_PROJECT_FILTER_TASK_H_
